Public Class Form1

    Public retCode, hContext, hCard, Protocol, pollCase As Long
    Public connActive As Boolean = False
    Public autoDet, dualPoll, detect As Boolean
    Public SendBuff(262), RecvBuff(262) As Byte
    Public SendLen, RecvLen, nBytesRet, ATRLen As Integer
    Dim ATRVal(256) As Byte
    Public RdrState As SCARD_READERSTATE
    Public ioRequest As SCARD_IO_REQUEST
    Dim dwState, dwActProtocol As Long

    Private Sub initmenu()

        mMsg.Text = ""
        cbOpt1.Checked = False
        cbOpt2.Checked = False
        cbOpt3.Checked = False
        cbOpt4.Checked = False
        cbOpt5.Checked = False
        cbOpt6.Checked = False
        cbOpt7.Checked = False
        bInit.Enabled = True
        bConnect.Enabled = False
        pollTimer.Enabled = False
        gbPollOpt.Enabled = False
        bStartPoll.Enabled = False
        Call displayOut(0, 0, "Program ready")
        detect = False


    End Sub

    Private Sub EnableButtons()

        bInit.Enabled = False
        bConnect.Enabled = True
        bReset.Enabled = True
        bClear.Enabled = True

    End Sub

    Private Sub ClearBuffers()

        Dim indx As Long

        For indx = 0 To 262

            RecvBuff(indx) = &H0
            SendBuff(indx) = &H0

        Next indx

    End Sub

    Private Sub displayOut(ByVal errType As Integer, ByVal retVal As Integer, ByVal PrintText As String)

        Select Case errType

            Case 0
                mMsg.SelectionColor = Drawing.Color.Green
                mMsg.SelectedText = PrintText & vbCrLf
            Case 1
                mMsg.SelectionColor = Drawing.Color.Red
                PrintText = ModWinsCard.GetScardErrMsg(retVal)
                mMsg.SelectedText = PrintText & vbCrLf

            Case 2
                mMsg.SelectionColor = Drawing.Color.Black
                PrintText = "<" + PrintText
                mMsg.SelectedText = PrintText & vbCrLf
            Case 3
                mMsg.SelectionColor = Drawing.Color.Black
                PrintText = ">" + PrintText
                mMsg.SelectedText = PrintText & vbCrLf
            Case 4
                mMsg.SelectionColor = Drawing.Color.Red
                PrintText = ">" + PrintText
                mMsg.SelectedText = PrintText & vbCrLf

            Case 5
                mMsg.SelectionColor = Drawing.Color.Black
                tsMsg4.Text = PrintText

            Case 6
                mMsg.SelectionColor = Drawing.Color.Black
                tsMsg2.Text = PrintText

            Case 7
                mMsg.SelectionColor = Drawing.Color.Purple
                mMsg.SelectedText = PrintText & vbCrLf

        End Select

        mMsg.Focus()

    End Sub

    Public Sub LoadListToControl(ByVal Ctrl As ComboBox, ByVal ReaderList As String)

        Dim sTemp As String
        Dim indx As Integer

        indx = 1
        sTemp = ""
        Ctrl.Items.Clear()

        While (Mid(ReaderList, indx, 1) <> vbNullChar)

            While (Mid(ReaderList, indx, 1) <> vbNullChar)
                sTemp = sTemp + Mid(ReaderList, indx, 1)
                indx = indx + 1
            End While

            indx = indx + 1

            Ctrl.Items.Add(sTemp)

            sTemp = ""
        End While

    End Sub

    Private Sub bInit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bInit.Click


        Dim ReaderCount As Integer
        Dim ctr As Integer
        Dim sReaderList As String


        For ctr = 0 To 255
            sReaderList = sReaderList + vbNullChar
        Next

        ReaderCount = 255

        ' 1. Establish context and obtain hContext handle
        retCode = ModWinsCard.SCardEstablishContext(ModWinsCard.SCARD_SCOPE_USER, 0, 0, hContext)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Call displayOut(1, retCode, "")

            Exit Sub

        End If

        ' 2. List PC/SC card readers installed in the system
        retCode = ModWinsCard.SCardListReaders(hContext, "", sReaderList, ReaderCount)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Call displayOut(1, retCode, "")

            Exit Sub

        End If

        ' Load Available Readers
        Call LoadListToControl(cbReader, sReaderList)
        cbReader.SelectedIndex = 0
        Call EnableButtons()

    End Sub

    Private Sub bConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bConnect.Click

        ' Connect to selected reader using hContext handle and obtain hCard handle
        If connActive Then

            retCode = ModWinsCard.SCardDisconnect(hCard, ModWinsCard.SCARD_UNPOWER_CARD)

        End If

        ' Shared Connection
        retCode = ModWinsCard.SCardConnect(hContext, cbReader.SelectedItem.ToString(), ModWinsCard.SCARD_SHARE_SHARED, ModWinsCard.SCARD_PROTOCOL_T0 Or ModWinsCard.SCARD_PROTOCOL_T1, hCard, Protocol)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then
            Exit Sub


        Else

            Call displayOut(0, 0, "Successful connection to " & cbReader.Text)

        End If

        connActive = True
        cbOpt1.Checked = True
        cbOpt2.Checked = True
        cbOpt3.Checked = True
        cbOpt4.Checked = True
        cbOpt5.Checked = True
        cbOpt6.Checked = True
        cbOpt7.Checked = True
        pollTimer.Enabled = True
        gbPollOpt.Enabled = True
        bStartPoll.Enabled = True
        Call displayOut(0, 0, "Program ready")

    End Sub

    Private Function Transmit() As Long

        'Display Apdu In

        ioRequest.dwProtocol = Protocol
        ioRequest.cbPciLength = Len(ioRequest)

        RecvLen = 262

        'Issue SCardTransmit
        retCode = ModWinsCard.SCardTransmit(hCard, _
                             ioRequest, _
                             SendBuff(0), _
                             SendLen, _
                             ioRequest, _
                             RecvBuff(0), _
                             RecvLen)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Call displayOut(1, retCode, "")

        End If

        Transmit = retCode

    End Function

    Private Sub getParam()

        'get the PICC Operating Parameter of the reader.
        Call ClearBuffers()
        SendBuff(0) = &HFF
        SendBuff(1) = &H0
        SendBuff(2) = &H50
        SendBuff(3) = &H0
        SendBuff(4) = &H0
        SendLen = 5
        RecvLen = 2

        retCode = Transmit()

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Exit Sub

        End If

    End Sub
    Private Sub bGetPollOpt_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bGetPollOpt.Click

        Dim tmpStr As String
        Dim indx As Integer

        Call getParam()

        'prints the command sent
        For indx = 0 To SendLen - 1

            tmpStr = tmpStr + Microsoft.VisualBasic.Right("00" & Hex(SendBuff(indx)), 2) + " "

        Next indx

        Call displayOut(2, 0, tmpStr)

        'print the response recieved
        tmpStr = ""

        For indx = 0 To RecvLen - 1

            tmpStr = tmpStr + Microsoft.VisualBasic.Right("00" & Hex(RecvBuff(indx)), 2) + " "

        Next indx

        Call displayOut(3, 0, Trim(tmpStr))

        'interpret the return response
        If (RecvBuff(0) And &H80) <> 0 Then

            Call displayOut(3, 0, "Automatic Polling is enabled.")
            cbOpt1.Checked = True

        Else

            Call displayOut(3, 0, "Automatic Polling is disabled.")
            cbOpt1.Checked = False

        End If

        If (RecvBuff(0) And &H40) <> 0 Then

            Call displayOut(3, 0, "Automatic ATS Generation is enabled.")
            cbOpt2.Checked = True

        Else

            Call displayOut(3, 0, "Automatic ATS Generation is disabled.")
            cbOpt2.Checked = False

        End If

        If (RecvBuff(0) And &H20) <> 0 Then

            Call displayOut(3, 0, "250 ms.")
            opt250.Checked = True

        Else

            Call displayOut(3, 0, "500 ms.")
            opt500.Checked = True

        End If

        If (RecvBuff(0) And &H10) <> 0 Then

            Call displayOut(3, 0, "Detect Felica 424K Card Enabled")
            cbOpt7.Checked = True

        Else

            Call displayOut(3, 0, "Detect Felica 424K Card Disabled")
            cbOpt7.Checked = False

        End If

        If (RecvBuff(0) And &H8) <> 0 Then

            Call displayOut(3, 0, "Detect Felica 212K Card Enabled")
            cbOpt6.Checked = True

        Else

            Call displayOut(3, 0, "Detect Felica 212K Card Disabled")
            cbOpt6.Checked = False

        End If

        If (RecvBuff(0) And &H4) <> 0 Then

            Call displayOut(3, 0, "Detect Topaz Card Enabled")
            cbOpt5.Checked = True

        Else

            Call displayOut(3, 0, "Detect Topaz Card Disabled")
            cbOpt5.Checked = False

        End If

        If (RecvBuff(0) And &H2) <> 0 Then

            Call displayOut(3, 0, "Detect ISO14443 Type B Card Enabled")
            cbOpt4.Checked = True

        Else

            Call displayOut(3, 0, "Detect ISO14443 Type B Card Disabled")
            cbOpt4.Checked = False

        End If

        If (RecvBuff(0) And &H1) <> 0 Then

            Call displayOut(3, 0, "Detect ISO14443 Type A Card Enabled")
            cbOpt3.Checked = True

        Else

            Call displayOut(3, 0, "Detect ISO14443 Type A Card Disabled")
            cbOpt3.Checked = False

        End If

    End Sub

    Private Sub bSetPollOpt_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bSetPollOpt.Click

        Dim tmpStr As String
        Dim indx As Integer

        'set the PICC Operating Parameter of the reader.
        Call ClearBuffers()
        SendBuff(0) = &HFF
        SendBuff(1) = &H0
        SendBuff(2) = &H51
        SendBuff(3) = &H0

        If cbOpt3.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H1
            Call displayOut(3, 0, "Detect ISO14443 Type A Card Enabled")

        Else

            Call displayOut(3, 0, "Detect ISO14443 Type A Card Disabled")

        End If

        If cbOpt4.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H2
            Call displayOut(3, 0, "Detect ISO14443 Type B Card Enabled")
        Else

            Call displayOut(3, 0, "Detect ISO14443 Type B Card Disabled")

        End If

        If cbOpt5.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H4
            Call displayOut(3, 0, "Detect Topaz Card Enabled")

        Else

            Call displayOut(3, 0, "Detect Topaz Card Disabled")

        End If

        If cbOpt6.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H8
            Call displayOut(3, 0, "Detect FeliCa 212K Card Enabled")

        Else

            Call displayOut(3, 0, "Detect FeliCa 212K Card Disabled")

        End If

        If cbOpt7.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H10
            Call displayOut(3, 0, "Detect FeliCa 424K Card Enabled")

        Else

            Call displayOut(3, 0, "Detect Felica 424K Card Disabled")

        End If

        If opt250.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H20
            pollTimer.Interval = 250
            Call displayOut(3, 0, "Poll Interval is 250 ms")

        Else

            pollTimer.Interval = 500
            Call displayOut(3, 0, "Poll Interval is 500 ms")

        End If

        If cbOpt2.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H40
            Call displayOut(3, 0, "Automatic ATS Generation is Enabled")

        Else

            Call displayOut(3, 0, "Automatic ATS Generation is Disabled")

        End If

        If cbOpt1.Checked = True Then

            SendBuff(3) = SendBuff(3) Or &H80
            Call displayOut(3, 0, "Automatic PICC Polling is Enabled")

        Else

            Call displayOut(3, 0, "Automatic PICC Polling is Disabled")

        End If

        SendBuff(4) = &H0

        SendLen = 5
        RecvLen = 1

        'prints the command sent
        For indx = 0 To SendLen - 1

            tmpStr = tmpStr + Microsoft.VisualBasic.Right("00" & Hex(SendBuff(indx)), 2) + " "

        Next indx

        Call displayOut(2, 0, tmpStr)

        retCode = Transmit()
        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Exit Sub

        End If

        'prints the response recievd
        tmpStr = ""

        For indx = 0 To RecvLen - 1

            tmpStr = tmpStr + Microsoft.VisualBasic.Right("00" & Hex(RecvBuff(indx)), 2) + " "

        Next indx

        Call displayOut(3, 0, Trim(tmpStr))
    End Sub

    Private Sub bClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bClear.Click

        mMsg.Clear()

    End Sub

    Private Sub bReset_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bReset.Click

        If connActive Then

            retCode = ModWinsCard.SCardDisconnect(hCard, ModWinsCard.SCARD_UNPOWER_CARD)

        End If

        retCode = ModWinsCard.SCardReleaseContext(hCard)
        Call initmenu()

    End Sub

    Private Sub bQuit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bQuit.Click

        ' terminate the application
        retCode = ModWinsCard.SCardReleaseContext(hContext)
        retCode = ModWinsCard.SCardDisconnect(hCard, ModWinsCard.SCARD_UNPOWER_CARD)
        End

    End Sub

    Private Sub bStartPoll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bStartPoll.Click

        If detect Then

            Call displayOut(7, 0, "Polling Stopped")
            bStartPoll.Text = "Start Polling"
            pollTimer.Enabled = False
            tsMsg2.Text = ""
            tsMsg4.Text = ""
            detect = False
            Exit Sub

        End If

        Call displayOut(7, 0, "Polling Started")
        bStartPoll.Text = "End Polling"
        pollTimer.Enabled = True
        detect = True

    End Sub

    Private Function CardConnect(ByVal connType As Integer) As Boolean

        If connActive Then

            retCode = ModWinsCard.SCardDisconnect(hCard, ModWinsCard.SCARD_UNPOWER_CARD)

        End If

        'Connect
        retCode = ModWinsCard.SCardConnect(hContext, _
                            cbReader.Text, _
                            ModWinsCard.SCARD_SHARE_SHARED, _
                            ModWinsCard.SCARD_PROTOCOL_T0 Or ModWinsCard.SCARD_PROTOCOL_T1, _
                            hCard, _
                            Protocol)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            If connType <> 1 Then
                Call displayOut(1, retCode, "")
            End If
            connActive = False
            CardConnect = retCode
            Exit Function

        Else

            If connType <> 1 Then

                Call displayOut(0, 0, "Successful connection to " & cbReader.Text)

            End If

            CardConnect = retCode

        End If

    End Function

    Private Sub pollTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles pollTimer.Tick

        'Always use a valid connection
        retCode = CardConnect(1)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            Call displayOut(5, 0, "No card within range.")
            tsMsg2.Text = ""
            Exit Sub

        End If

        If CheckCard() Then

            Call displayOut(5, 0, "Card is detected.")

        Else

            Call displayOut(5, 0, "No card within range.")
            tsMsg2.Text = ""

        End If

    End Sub

    Private Function CheckCard() As Boolean

        'Variable declaration
        Dim ReaderLen As Long
        Dim tmpWord As Long

        tmpWord = 32
        ATRLen = tmpWord

        retCode = ModWinsCard.SCardStatus(hCard, cbReader.Text, ReaderLen, dwState, dwActProtocol, ATRVal(0), ATRLen)

        If retCode <> ModWinsCard.SCARD_S_SUCCESS Then

            'Call DisplayOut(1, retCode, "")
            CheckCard = False
            Exit Function

        Else

            Call InterpretATR()
            CheckCard = True

        End If

    End Function

    Private Sub InterpretATR()

        Dim RIDVal, cardName, sATRStr, lATRStr, tmpVal As String
        Dim indx, indx2 As Integer

        ' 4. Interpret ATR and guess card
        ' 4.1. Mifare cards using ISO 14443 Part 3 Supplemental Document

        If CInt(ATRLen) > 14 Then

            RIDVal = ""
            sATRStr = ""
            lATRStr = ""

            For indx = 7 To 11

                RIDVal = RIDVal & Format(Hex(ATRVal(indx)))

            Next indx


            For indx = 0 To 4

                'shift bit to right
                tmpVal = ATRVal(indx)
                For indx2 = 1 To 4

                    tmpVal = tmpVal / 2

                Next indx2

                If ((indx = 1) And (tmpVal = 8)) Then

                    lATRStr = lATRStr + "8X"
                    sATRStr = sATRStr + "8X"

                Else

                    If indx = 4 Then

                        lATRStr = lATRStr + Format(Hex(ATRVal(indx)))

                    Else

                        lATRStr = lATRStr + Format(Hex(ATRVal(indx)))
                        sATRStr = sATRStr + Format(Hex(ATRVal(indx)))

                    End If

                End If

            Next indx

            ' Felica and Topaz Cards
            If ATRVal(12) = &H3 Then

                If ATRVal(13) = &HF0 Then

                    Select Case ATRVal(14)

                        Case &H11 : cardName = "FeliCa 212K"
                        Case &H12 : cardName = "Felica 424K"
                        Case &H4 : cardName = "Topaz"

                    End Select

                End If

            End If

            If ATRVal(12) = &H3 Then

                If ATRVal(13) = &H0 Then

                    Select Case ATRVal(14)

                        Case &H1 : cardName = cardName + " Mifare Standard 1K"
                        Case &H2 : cardName = cardName + " Mifare Standard 4K"
                        Case &H3 : cardName = cardName + " Mifare Ultra light"
                        Case &H4 : cardName = cardName + " SLE55R_XXXX"
                        Case &H6 : cardName = cardName + " SR176"
                        Case &H7 : cardName = cardName + " SRI X4K"
                        Case &H8 : cardName = cardName + " AT88RF020"
                        Case &H9 : cardName = cardName + " AT88SC0204CRF"
                        Case &HA : cardName = cardName + " AT88SC0808CRF"
                        Case &HB : cardName = cardName + " AT88SC1616CRF"
                        Case &HC : cardName = cardName + " AT88SC3216CRF"
                        Case &HD : cardName = cardName + " AT88SC6416CRF"
                        Case &HE : cardName = cardName + " SRF55V10P"
                        Case &HF : cardName = cardName + " SRF55V02P"
                        Case &H10 : cardName = cardName + " SRF55V10S"
                        Case &H11 : cardName = cardName + " SRF55V02S"
                        Case &H12 : cardName = cardName + " TAG IT"
                        Case &H13 : cardName = cardName + " LRI512"
                        Case &H14 : cardName = cardName + " ICODESLI"
                        Case &H15 : cardName = cardName + " TEMPSENS"
                        Case &H16 : cardName = cardName + " I.CODE1"
                        Case &H17 : cardName = cardName + " PicoPass 2K"
                        Case &H18 : cardName = cardName + " PicoPass 2KS"
                        Case &H19 : cardName = cardName + " PicoPass 16K"
                        Case &H1A : cardName = cardName + " PicoPass 16KS"
                        Case &H1B : cardName = cardName + " PicoPass 16K(8x2)"
                        Case &H1C : cardName = cardName + " PicoPass 16KS(8x2)"

                        Case &H1D : cardName = cardName + ": PicoPass 32KS(16+16)"
                        Case &H1E : cardName = cardName + ": PicoPass 32KS(16+8x2)"
                        Case &H1F : cardName = cardName + ": PicoPass 32KS(8x2+16)"
                        Case &H20 : cardName = cardName + ": PicoPass 32KS(8x2+8x2)"
                        Case &H21 : cardName = cardName + ": LRI64"
                        Case &H22 : cardName = cardName + ": I.CODE UID"
                        Case &H23 : cardName = cardName + ": I.CODE EPC"
                        Case &H24 : cardName = cardName + ": LRI12"
                        Case &H25 : cardName = cardName + ": LRI128"
                        Case &H26 : cardName = cardName + ": Mifare Mini"

                    End Select

                Else

                    If ATRVal(13) = &HFF Then

                        Select Case ATRVal(14)

                            Case &H9
                                cardName = cardName & ": Mifare Mini."

                        End Select

                    End If

                End If

                Call displayOut(6, 0, cardName)

            End If

        End If

        '4.2. Mifare DESFire card using ISO 14443 Part 4
        If CInt(ATRLen) = 11 Then

            RIDVal = ""

            For indx = 4 To 9

                RIDVal = RIDVal & Format(Hex(ATRVal(indx)))

            Next indx

            If RIDVal = "6757781280" Then

                Call displayOut(6, 0, "Mifare DESFire")

            End If

        End If

        '4.3. Other cards using ISO 14443 Part 4
        If CInt(ATRLen) = 17 Then

            RIDVal = ""

            For indx = 4 To 15

                RIDVal = RIDVal & Format(Hex(RecvBuff(indx)), "00")

            Next indx

            If RIDVal = "50122345561253544E3381C3" Then

                Call displayOut(6, 0, "ST19XRC8E")

            End If

        End If

        '4.4. other cards using ISO 14443 Type A or B
        If lATRStr = "3B8X800150" Then

            Call displayOut(6, 0, "ISO 14443B.")

        Else

            If sATRStr = "3B8X8001" Then

                Call displayOut(6, 0, "ISO 14443A")

            End If

        End If


    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Call initmenu()

    End Sub

End Class
